REM Startscript for Philips Rustdesk Client by Thomas Jelinek in Nov 2025
@echo off
setlocal
set "DIR=%APPDATA%\RustDesk\config"
set "BASE=%APPDATA%\RustDesk"
set "CFG=%DIR%\RustDesk2.toml"

for /f "tokens=1-4 delims=/. " %%a in ("%date%") do set "DATEVAR=%%c-%%b-%%a"
for /f "tokens=1-3 delims=:," %%a in ("%time%") do set "TIMEVAR=%%a-%%b-%%c"
set "STAMP=%DATEVAR%_%TIMEVAR%"
set "BACKUP=%BASE%\config_backup_%STAMP%.zip"

for /f "tokens=1" %%i in ('tasklist /fi "imagename eq rustdesk*" /nh') do taskkill /f /im "%%i" >nul 2>&1

if exist "%DIR%\" (
  REM Prüfen, ob die Config bereits die gewünschte Zeile enthält
  findstr /C:"custom-rendezvous-server = 'phi-support.de:5938'" "%CFG%" >nul 2>&1
  if not errorlevel 1 (
    echo Konfiguration enthaelt bereits Philips-Server; ueberspringe Schreiben/Backup.
    goto startclient
  )

  echo Kompletten Config-Ordner sichern ^(inkl. Unterordner^) und Philips-Server eintragen? & echo Falls noetig, alte config zurueckspielen nach %APPDATA%\RustDesk\config & echo Backup-zips im Ordner %APPDATA%\RustDesk\
  choice /C JN /N /M "Fortfahren (J/N): "
  if errorlevel 2 goto writecfg

  powershell -NoLogo -NoProfile -Command "Compress-Archive -LiteralPath '%DIR%' -DestinationPath '%BACKUP%' -Force"
  echo Backup erstellt: "%BACKUP%"

  del /q /a:-d "%DIR%\*"
  echo Root-Dateien in "%DIR%" geloescht, Unterordner unveraendert.
) else (
  goto writecfg
)

:writecfg
if not exist "%DIR%" mkdir "%DIR%"
> "%CFG%" (
  echo rendezvous_server = 'phi-support.de:5938'
  echo nat_type = 2
  echo serial = 0
  echo unlock_pin = ''
  echo trusted_devices = ''
  echo.
  echo [options]
  echo av1-test = 'N'
  echo key = 'ViILKnHvCsUpRHrKlQqyw98yUL9GCTEXWvXyHUwb4UA='
  echo custom-rendezvous-server = 'phi-support.de:5938'
)
echo Datei geschrieben: "%CFG%"

:startclient
cd /d "%~dp0"
start "" rustdesk-1.4.4-x86_64.exe
endlocal
exit
